/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: doors.h,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland MUDlib
//
// SYS/DOORS.H -- Door Defines
//
// $Revision: 1.1.1.1 $
//
// $Log: doors.h,v $
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:15  en
// MUDLib CVS Preperation
//

#ifndef __DOORS_H__
#define __DOORS_H__

// Properties
#define P_DOORS              "doors"

// Door Status
#define DS_OPEN        1
#define DS_LOCKED      2
#define DS_BROKEN      4
#define DS_DESTRUCTED  8

// Door Flags
#define DF_AUTO_CLOSE      1  // Schliessen in jedem Reset
#define DF_AUTO_OPEN       2  // Oeffnen in jedem Reset
#define DF_AUTO_LOCK       4  // Abschliessen in jedem Reset
#define DF_AUTO_REPAIR     8  // Aufgebrochenes Schloss Reparieren im Reset
#define DF_AUTO_RENEW     16  // Demolierte Tuer erneuern in jedem Reset
#define DF_CLOSE_PASS     32  // Schliessen nach Durchschreiten
#define DF_CLOSE_PASS2    64  // Schliesse kurze Zeit nach Durchschreiten
#define DF_LOCKABLE      128  // Abschliessbar
#define DF_LOCK_ALWAYS   256  // Abschliessen bei jedem Schliessen
#define DF_UNBREAKABLE   512  // Tuerschloss kann man knacken
#define DF_DESTRUCTABLE 1024  // Tuer ist zerstoerbar

// Door Events
#define ET_DOOR_OPEN     "et_door_open"
#define ET_DOOR_CLOSE    "et_door_close"
#define ET_DOOR_LOCK     "et_door_lock"
#define ET_DOOR_UNLOCK   "et_door_unlock"
#define ET_DOOR_BREAK    "et_door_break"
#define ET_DOOR_REPAIR   "et_door_repair"
#define ET_DOOR_DESTRUCT "et_door_destruct"
#define ET_DOOR_RENEW    "et_door_renew"

// Door Event Keys (fuer alle Events)
#define E_DOOR         "e_door"
#define E_DOOR_DEST    "e_door_dest"
#define E_DOOR_ROOM    "e_door_room"
#define E_DOOR_ACTOR   "e_door_actor"
#define E_DOOR_MSGS    "e_door_msgs"
#define E_DOOR_KEY     "e_door_key"

#endif // __DOORS_H__

#ifdef NEED_PROTOTYPES

#ifndef __DOORS_H_PROTO__
#define __DOORS_H_PROTO__

public mixed QueryDoorProp(string cmd, string prop);
public int SetDoorProp(string cmd, string prop, mixed value);
public string QueryDoorLong(string cmd);
public string QueryAllDoorLong();

#endif // __DOORS_H_PROTO__
#endif // NEED_PROTOTYPES

