/*******************
** Eldarea MUDLib **
********************
**
** sys/living/attributes.h - living attributes header
**
** CVS DATA
** $Date: 2000/12/04 14:52:25 $
** $Revision: 1.4 $
**
** CVS History
**
** $Log: attributes.h,v $
** Revision 1.4  2000/12/04 14:52:25  elatar
** #define A_AP removed
** #define ALL_ATTRIBUTES changed
**
** Revision 1.3  2000/03/13 11:13:47  elatar
** primary attribute handling finished
**
** Revision 1.2  1999/12/14 15:46:55  elatar
** ATTR_DESC added
**
** Revision 1.1.1.1  1999/11/05 12:30:48  elatar
** Preparing mudlib for cvs control
**
**
*/
 
#ifndef __LIVING_ATTRIBUTES_H__
#define __LIVING_ATTRIBUTES_H__

// properties

#define P_ATTRIBUTES 	      	"attributes"		// Attribute
#define P_ATTR_BONI             "attr_boni"		// Attributboni
#define P_ATTRIBUTES_OFFSETS    "attributes_offsets"  	// Obsolet
#define P_ATTR_OFFSETS          "attr_offsets"  	// Raceboni
#define P_ATTRIBUTES_MAGIC	"attributes_magic"	// Attribute magisch veraendert?
#define P_ATTR_BONI_MAGIC	"attr_boni_magic"	// Bonus magisch veraendert?
#define P_ABILITIES             "abilities"             //Obsolet!
#define P_ATTRIBUTES_MODIFIER   "attributes_modifier"   //dito
#define P_RESISTANCES           "resistances"		// Widerstandwerte
#define P_RESISTANCES_MAGIC	"resistances_magic"	// RR magisch veraendert?
#define P_RESIST_OFFSETS        "resist_offsets"        // Raceboni
#define P_ATTRIBUTES_USE        "attributes_use"        // Wie oft wurden die Attribute benutzt?

/* standard attributes */ //Obsolet, for compat!
#define A_STR "str"
#define A_INT "int"
#define A_DEX "dex"
#define A_CON "con"
#define A_CHA "cha"

// New standard attributes
#define A_ST "a_st"
#define A_AG "a_ag"
#define A_QU "a_qu"
#define A_CO "a_co"
#define A_SD "a_sd"
#define A_RE "a_re"
#define A_ME "a_me"
#define A_IN "a_in"
#define A_EM "a_em"
#define A_PR "a_pr"

// New resistances
#define RR_ESSENCE	"rr_essence"
#define RR_CHANNELING	"rr_channeling"
#define RR_MENTALISM	"rr_mentalism"
#define RR_DISEASE	"rr_disease"
#define RR_POISON	"rr_poison"
#define RR_PSIONS	"rr_psions"
#define RR_FEAR		"rr_fear"
#define RR_POWERDRAIN	"rr_powerdrain"
#define RR_ELEMENTAL	"rr_elemental"

/* standard MAXIMUM attributes */ //Obsolet!
#define A_MAX_STR "attr_max_str"
#define A_MAX_INT "attr_max_int"
#define A_MAX_DEX "attr_max_dex"
#define A_MAX_CON "attr_max_con"
#define A_MAX_CHA "attr_max_cha"

// special defines

// attribute descriptions
#define ATTR_DESC ([A_ST:"Staerke",\
                    A_AG:"Geschicklichkeit",\
                    A_QU:"Reaktion",\
                    A_CO:"Konstitution",\
                    A_SD:"Selbstdisziplin",\
                    A_RE:"Intelligenz",\
                    A_IN:"Intuition",\
                    A_EM:"Mana",\
                    A_PR:"Charisma"])

#define PHYSICAL_ATTRIBUTES ({A_ST,A_AG,A_QU,A_CO})
#define MENTAL_ATTRIBUTES ({A_SD,A_RE,A_IN,A_EM,A_PR})
#define ALL_ATTRIBUTES ({A_ST,A_AG,A_QU,A_CO,A_SD,A_RE,A_IN,A_EM,A_PR})

// zero attributes preset
#define ZEROATT ([A_ST:0,\
                  A_AG:0,\
                  A_QU:0,\
                  A_CO:0,\
                  A_SD:0,\
                  A_RE:0,\
                  A_IN:0,\
                  A_EM:0,\
                  A_PR:0])

// "zero" boni preset
#define ZEROBON ([A_ST:-30,\
                  A_AG:-30,\
                  A_QU:-30,\
                  A_CO:-30,\
                  A_SD:-30,\
                  A_RE:-30,\
                  A_IN:-30,\
                  A_EM:-30,\
                  A_PR:-30])


// resistance attribute boni
#define RESATTR ([RR_ESSENCE:A_EM,\
                  RR_CHANNELING:A_IN,\
                  RR_MENTALISM:A_PR,\
                  RR_DISEASE:A_CO,\
                  RR_POISON:A_CO,\
                  RR_PSIONS:A_SD,\
                  RR_FEAR:A_SD,\
                  RR_POWERDRAIN:A_SD,\
                  RR_ELEMENTAL:A_CO])

// "zero" resistances preset
#define ZERORES ([RR_ESSENCE:-30,\
                  RR_CHANNELING:-30,\
                  RR_MENTALISM:-30,\
                  RR_DISEASE:-30,\
                  RR_POISON:-30,\
                  RR_PSIONS:-30,\
                  RR_FEAR:-30,\
                  RR_POWERDRAIN:-30,\
                  RR_ELEMENTAL:-30])

#endif // __LIVING_ATTRIBUTES_H__

#ifdef NEED_PROTOTYPES

#ifndef __LIVING_ATTRIBUTES_H_PROTO__
#define __LIVING_ATTRIBUTES_H_PROTO__

// prototypes

int SetAttr(string attr, int val);
int SetAttribute(string attr, int val);
int QueryAttribute(string attr);
/*
int QueryRealAttribute(string attr);
int QueryAttributeOffset(string attr);
int QueryAttributeBonus(string attr);
int QueryRealAttributeBonus(string attr);
*/
// Offene Funktionen zu Verwendung von aussen

int AttributeCheck(string key, int difficulty);
int ResistanceCheck(string key, int difficulty);

int AddMod(string prop, string key, int value);
int AddTempMod(string prop, string key, int value, int secs);
int DelMod(string prop, string key, int value);

int ModAtt(string key, int mod);

int UseAtt(string key);
int UseAttBon(string key);
int UseResist(string key);

string RaiseAtt();

// obsolet
int SetAbility(string abil, int val);
int QueryAbility(string abil);

mapping QueryStatMod(object pl);

static void UpdateAll(string prop, mapping map);
static int ValueToBonus(int value);
static void UpdateAttributeBoni(mapping oldboni);
static void UpdateResistances(mapping oldboni);
varargs static void UpdateAttributes(mapping map);
static void UpAtt(string key, int value, mapping map);
static void UpBon(string key,int value,mapping map);
static void UpRes(string key,int value,mapping map);
static void AddVals(string key,int value,mapping map);

static void OneUse(string key);

static mapping _set_attributes(mapping arr);

static mapping _query_attributes_use();
static mapping _query_attr_offsets();
static mapping _query_resist_offsets();
#endif // __LIVING_ATTRIBUTES_H_PROTO__

#endif // NEED_PROTOYPES

