/*******************
** Eldarea MUDLib **
********************
**
** /sys/living/combat.h - living combat header
**
** CVS DATA
** $Date: 2000/12/04 14:53:25 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: combat.h,v $
** Revision 1.2  2000/12/04 14:53:25  elatar
** various new defines
** various new function prototypes
**
** Revision 1.1.1.1  1999/11/05 12:30:48  elatar
** Preparing mudlib for cvs control
**
**
*/

#ifndef __LIVING_COMBAT_H__
#define __LIVING_COMBAT_H__

// properties

// next two obsolet
#define P_RESISTANCE            "resistance"
#define P_VULNERABILITY         "vulnerability"
// instead this one
#define P_DAMAGE_RESISTANCES    "damage_resistances"
#define P_TOTAL_AC              "total_ac"

#define P_HANDS                 "hands"
#define P_MAX_HANDS             "max_hands"
#define P_USED_HANDS            "used_hands"

// Kein Begruessungsschlag, z.B. beim Casten eines Spells.
#define P_NO_ATTACK             "no_attack"
#define P_PK_LEVEL              "pk_level"      
#define P_INITIATIVE            "initiative"
#define P_DB                    "db"
#define P_INHERENT_DB           "inherent_db"

// Prozentualer Anteil Attacke/Parade
#define P_ATTACK_WEIGHT         "attack_weight"

// hooks. weirdos :)
#define P_ATTACK_HOOKS          "attack_hooks" 
#define P_DEFEND_HOOKS          "defend_hooks" 
#define P_WEAR_HOOKS            "wear_hooks"
#define P_UNWEAR_HOOKS          "unwear_hooks"

#endif // __LIVING_COMBAT_H__

#ifdef NEED_PROTOTYPES

#ifndef __LIVING_COMBAT_H_PROTO__
#define __LIVING_COMBAT_H_PROTO__

// prototypes

int Kill(object ob);
int InsertEnemy(object ob);
int IsEnemy(object wer);
mixed EnemyPresent();
mixed InFight();

varargs int StopHuntFor(mixed arg, int silent);
varargs int StopHuntID(string str, int silent);
varargs mixed StopHuntingMode(int silent);

private void FumbleHands(object enemy);
private void FailAttack(object enemy);
private void FumbleWeapon(object weapon, object enemy);
private int EvadeAttack(object enemy);
private void HandAttack(object enemy);
varargs int Hit(int damage, mixed dam_type, string hit_location);
varargs int CombatHit(int damage, mixed dam_type, object enemy, string att_type, string location, int depth);
private varargs void WeaponAttack(object weapon, object enemy,int mod);
private int DoAttack(object enemy, string dam_msg, string dam_msg2, int damage, mixed damage_type,string attack_type, int roll);
void Attack(object enemy);
varargs int Defend(int dam, mixed dam_type, int spell, object enemy, int roll, string att_type);
static void Flee();

static int CheckResistance(string* dam_type, int damage);

object QueryEnemy();
mixed QueryEnemies();

// useful methods
varargs void SetAttackHook(object ob, string fun, int expire);
varargs void SetDefendHook(object ob, string fun, int expire);
void DelAttackHook(object ob);
void DelDefendHook(object ob);
int UpdateInitiative(int oldval,int newval);
int AddIniMod(int mod);
int DelIniMod(int mod);
int AddTempIniMod(int mod, int secs);

nomask void did_pk(object attacking, object defending);

#endif // __LIVING_COMBAT_H_PROTO__

#endif // NEED_PROTOYPES
