/*******************
** Eldarea MUDLib **
********************
**
** /sys/living/life.h - living life header
**
** CVS DATA
** $Date: 2001/02/01 09:45:56 $
** $Revision: 1.5 $
**
** CVS History
**
** $Log: life.h,v $
** Revision 1.5  2001/02/01 09:45:56  elatar
** event defines implemented
**
** Revision 1.4  2000/12/15 15:36:28  elatar
** inserted death event defines
** inserted die flag defines
**
** Revision 1.3  2000/12/04 14:55:16  elatar
** various new defines (properties)
** various new function prototypes
**
** Revision 1.2  2000/01/25 16:56:37  elatar
** new properties added
**
** Revision 1.1.1.1  1999/11/05 12:30:48  elatar
** Preparing mudlib for cvs control
**
**
*/
 
#ifndef __LIVING_LIFE_H__
#define __LIVING_LIFE_H__

#define P_AGE                   "age"
#define P_AGE_MONTHLY           "age_monthly"
#define P_ALIGN                 "align"
#define P_ASPECT                "aspect"
#define P_CIVILIZATION          "civilization"
#define P_HONOR                 "honor"
#define P_SIZE                  "size"

#define P_GHOST                 "ghost"
#define P_FROG                  "frog"
#define P_UNDEAD                "undead"

#define P_FOOD                  "food"       
#define P_MAX_FOOD              "max_food"   
#define P_FOOD_DELAY            "food_delay"
#define P_HUNGER                "hunger"

#define P_DRINK                 "drink"
#define P_MAX_DRINK             "max_drink"
#define P_DRINK_DELAY           "drink_delay"
#define P_THIRST                "thirst"

#define P_TIREDNESS             "tiredness"

#define P_ALCOHOL               "alcohol"
#define P_MAX_ALCOHOL           "max_alcohol"
#define P_ALCOHOL_DELAY         "alcohol_delay"

#define P_POISON_DELAY          "poison_delay"

#define P_EXP                   "exp"
#define P_MAX_EXP               "max_exp"
#define P_EXP_OFFSET            "exp_offset"
#define P_EXP_MULTIPLIER        "exp_multiplier"
#define P_EXP_DELAY             "exp_delay"
#define P_EXP_MOD               "exp_mod"

#define P_HP                    "hp"
#define P_MAX_HP                "max_hp"
#define P_HP_OFFSET	            "hp_offset"
#define P_HP_MULTIPLIER	        "hp_multiplier"
#define P_HEAL_DELAY            "heal_delay"
#define P_HP_MOD                "hp_mod"

// obsolet
#define P_SP                    "sp"
#define P_MAX_SP                "max_sp"

#define P_PSP                   "psp"
#define P_MAX_PSP               "max_psp"
#define P_PSP_OFFSET            "psp_offset"
#define P_PSP_MULTIPLIER	      "psp_multiplier"
#define P_PSP_DELAY	            "psp_delay"
#define P_PSP_MOD               "psp_mod"
#define P_CSP                   "csp"
#define P_MAX_CSP               "max_csp"
#define P_CSP_OFFSET            "csp_offset"
#define P_CSP_MULTIPLIER	      "csp_multiplier"
#define P_CSP_DELAY	            "csp_delay"
#define P_CSP_MOD               "cps_mod"
#define P_ESP                   "esp"
#define P_MAX_ESP               "max_esp"
#define P_ESP_OFFSET            "esp_offset"
#define P_ESP_MULTIPLIER	      "esp_multiplier"
#define P_ESP_DELAY	            "esp_delay"
#define P_ESP_MOD               "esp_mod"
#define P_MSP                   "msp"
#define P_MAX_MSP               "max_msp"
#define P_MSP_OFFSET            "msp_offset"
#define P_MSP_MULTIPLIER	      "msp_multiplier"
#define P_MSP_DELAY	            "msp_delay"
#define P_MSP_MOD               "msp_mod"

#define P_XP                    "xp"

#define FROG_NAME        0
#define FROG_GENDER      1
#define FROG_TITLE       2
#define FROG_PRESAY      3
#define FROG_IDS         4
#define FROG_SHOUT       5
#define FROG_MSGIN       6
#define FROG_MSGOUT      7
#define FROG_ADJ         8

#define UNDEAD_NONE      0
#define UNDEAD_SKELETON  1
#define UNDEAD_ZOMBIE    2
#define UNDEAD_GHOUL     3
#define UNDEAD_SHADOW    4
#define UNDEAD_WIGHT     5
#define UNDEAD_GHAST     6
#define UNDEAD_WRAITH    7
#define UNDEAD_MUMMY     8
#define UNDEAD_SPECTRE   9
#define UNDEAD_VAMPIRE  10
#define UNDEAD_GHOST    11
#define UNDEAD_LICH     12
#define UNDEAD_SPECIAL  13

// event defines
#define ET_DEATH            "et_death"
#define ET_EXHAUST          "et_exhaust"

#define E_DEATH_VICTIM      "e_death_victim"
#define E_DEATH_KILLER      "e_death_killer"
#define E_DEATH_FLAGS       "e_death_flags"
#define E_DEATH_RMSG        "e_death_rmsg"
#define E_DEATH_PMSG        "e_death_pmsg"
#define E_DEATH_CORPSE      "e_death_corpse"
#define E_DEATH_CORPSE_OBJ  "e_death_corpse_obj"

#define E_EXHAUST_EXHAUST   "e_exhaust_exhaust"

// death event handle modes
#define DEAD             1
#define IMMORTAL         2

// die methods/flags
#define DIE_SILENT       1  // no messages will be made
#define DIE_NOEVENT      2  // no event will be sent
#define DIE_POISON       4  // death because of posion
#define DIE_COLD         8  // death because of frost
#define DIE_HEAT        16  // death because of heat
#define DIE_NOCORPSE    32  // no corpse will be generated
#define DIE_REMOVE_INV  64  // the complete inventory be removed
#define DIE_DIRECT     128  // die() was called directly
#define DIE_NOEP       256  // no ep are given

#endif // __LIVING_LIFE_H__

#ifdef NEED_PROTOTYPES

#ifndef __LIVING_LIFE_H_PROTO__
#define __LIVING_LIFE_H_PROTO__         

int AddExp(int e);
void show_age();
int eat_food(int strength);
int drink_soft(int strength);
int drink_alcohol(int strength);
varargs void die(int flags, string rmsg, string pmsg);
int do_damage(int dam, mixed enemy);
int reduce_hit_point(int dam);
int restore_spell_points(int h);
int restore_psp(int h);
int restore_esp(int h);
int restore_msp(int h);
int restore_csp(int h);
void heal_self(int h);
float sp_per_level(int att);
int do_exhaust(int ex);

// property methods

static int _query_max_hp();
static int _query_max_psp();
static int _query_max_msp();
static int _query_max_csp();
static int _query_max_esp();
static int _set_align(int a);
static int _set_hp(int hp);
static int _set_sp(int sp);
static int _set_csp(int csp);
static int _set_esp(int esp);
static int _set_msp(int msp);
static int _set_psp(int psp);
static int _set_alcohol(int n);
static int _set_drink(int n);
static int _set_food(int n);
static int _set_poison(int n);
static int _query_age();
static int _set_xp(int xp);        

#endif // __LIVING_LIFE_H_PROTO__

#endif // NEED_PROTOYPES
