/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 2000/12/04 14:56:03 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: skills.h,v $
** Revision 1.2  2000/12/04 14:56:03  elatar
** nearly completely new due to new skill handling
**
** Revision 1.1.1.1  1999/11/05 12:30:48  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland Mudlib
//
// SYS/LIVING/SKILLS.H -- living-skills-header
//
// Based on Morgengrauen Mulib
//
// $Log: skills.h,v $
// Revision 1.2  2000/12/04 14:56:03  elatar
// nearly completely new due to new skill handling
//
// Revision 1.1.1.1  1999/11/05 12:30:48  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:15  en
// MUDLib CVS Preperation
//
// Revision 1.5  1998/11/04 18:19:56  Holger
// P_SKILLS_ID eund Prototype eingebaut
//
 
#ifndef __LIVING_SKILLS_H__
#define __LIVING_SKILLS_H__

/* Vorlaeufige neue Properties. Werden bereits beim combat gebraucht. */

#define P_GLOBAL_MOD            "global_mod"
#define P_NEXTCHECK_MOD         "nextcheck_mod"

// Neues Skill Handling. Jeder hat alle Skills 
// Format:
// ([SK_SKILL:"Name";ranks;bonus;learncost;uses;lastuses;({attributes})])
//
#define P_SKILLS                "skills"      
#define P_SKILL_MOD             "skill_mod"  // extra boni for skills
// active skills
// Format ([skill:int bonus;int expire;mixed extra])
// bonus   - How successful was the skill check
// expire  - time() when the skill is to expire
// extra   - extra info needed by skill resolvment
#define P_ACTIVE_SKILLS         "active_skills"

// development points
#define P_DP                    "dp"

// first 3 weapon skills
#define P_FIRST_WEAPON_SKILLS   "first_weapon_skills"

// skill mapping indices
#define SI_NAME                0 // german skill name
#define SI_RANKS               1 // skill ranks
#define SI_BONUS               2 // skill bonus (ONLY ranks)
#define SI_COST                3 // skill cost
#define SI_USES                4 // how often was the skill used?
#define SI_LASTU               5 // array of the last uses
#define SI_ATTR                6 // array with the skill relevant attributes
#define SI_LEARNED             7 // skill was learnt this level
// active skill mapping indices
#define ASI_SUCCESS            0 // how successful was the skill used
#define ASI_EXPIRE             1 // time() when the skill is to expire
#define ASI_EXTRA              2 // extra info needed for skill resolvment
#define ASI_CALLBACK           3 // expire callback (obj/filename,fun)

// all skills
// weapon skills
#define SK_SWORD                "sword"
#define SK_AXE                  "axe"
#define SK_STING                "sting"
#define SK_CLUB                 "club"
#define SK_POLE                 "pole"
#define SK_FLAIL                "flail"
#define SK_MARTIAL_ARTS         "martial_arts"
#define SK_ARCHERY              "archery"
#define SK_THROWING             "throwing"

// fighting skills
#define SK_DISARM               "disarm"
#define SK_FEINTING             "feinting"
#define SK_CLOSE_COMBAT         "close_combat"
#define SK_FURY                 "fury"
#define SK_FIGHT_HORSE          "fight_horse"
#define SK_QUICKFIGHT           "quickfight"
#define SK_ARMOUR               "armour"
#define SK_BODY_DEVELOPMENT     "body_development"

// athletic skills
#define SK_CLIMBING             "climbing"
#define SK_SWIMMING             "swimming"
#define SK_ACROBATICS           "acrobatics"
#define SK_ENDURANCE            "endurance"

// concentration skills
#define SK_PERCEPTION           "perception"
#define SK_EVADE                "evade"
#define SK_USE_STRENGTH         "use_strength"
#define SK_RESIST_PAIN          "resist_pain"
#define SK_MEDITATION_HEAL      "meditation_heal"
#define SK_MEDITATION_SLEEP     "meditation_sleep"
#define SK_MEDITATION_POWER     "meditation_power"
#define SK_PORTAGING            "portaging"

// magical skills
#define SK_ESSENCE              "essence"
#define SK_CHANNELING           "channeling"
#define SK_MENTALISM            "mentalism"
#define SK_RITUALS              "rituals"
#define SK_PSIONS               "psions"
#define SK_POWER_PERCEPTION     "power_perception"
#define SK_HIDE_SPELLS          "hide_spells"
#define SK_STRENGTHEN_SPELLS    "strengthen_spells"
#define SK_CHANNEL_POWER        "channel_power"
#define SK_TRANSCENDENCE        "transcendence"
#define SK_MAGIC_LORE           "magic_lore"
#define SK_RUNES                "runes"

// academic skills
#define SK_TACTICS              "tactics"
#define SK_ALCHEMY              "alchemy"
#define SK_FLORA_LORE           "flora_lore"
#define SK_METAL_LORE           "metal_lore"
#define SK_STONE_LORE           "stone_lore"
#define SK_NATURAL_LORE         "natural_lore"
#define SK_ELEMENTAL_LORE       "elemental_lore"
#define SK_CREATURE_LORE        "creature_lore"
#define SK_WEAPON_LORE          "weapon_lore"
#define SK_ARMOUR_LORE          "armour_lore"

// medical skills
#define SK_FIRST_AID            "first_aid"
#define SK_SURGERY              "surgery"

// social skills
#define SK_DIPLOMACY            "diplomacy"
#define SK_TRADING              "trading"

// subterfuge skills
#define SK_LOCKS                "locks"
#define SK_TRAPS                "traps"
#define SK_THIEVERY             "thievery"
#define SK_STEALTH              "stealth"

// outdoor skills
#define SK_RIDING               "riding"
#define SK_ANIMAL_HANDLING      "animal_handling"
#define SK_FORAGING             "foraging"
#define SK_WILDERNESS           "wilderness"

// development defines
#define SK_FIRST_WEAPON         "first_weapon"
#define SK_SECOND_WEAPON        "second_weapon"
#define SK_THIRD_WEAPON         "third_weapon"
#define SK_OTHER_WEAPONS        "other_weapons"

// skill groups
#define SK_GROUP_WEAPON ([\
  SK_SWORD                :"Schwerter";0;0;0;0;({});({A_ST,A_AG});0,\
  SK_AXE                  :"Aexte";0;0;0;0;({});({A_ST,A_AG});0,\
  SK_STING                :"Stichwaffen";0;0;0;0;({});({A_ST,A_AG});0,\
  SK_CLUB                 :"Keulen";0;0;0;0;({});({A_ST,A_AG});0,\
  SK_POLE                 :"Stangenwaffen";0;0;0;0;({});({A_ST,A_AG});0,\
  SK_FLAIL                :"Kettenwaffen";0;0;0;0;({});({A_ST,A_AG});0,\
  SK_MARTIAL_ARTS         :"Waffenloser Kampf";0;0;0;0;({});({A_QU,A_AG});0,\
  SK_ARCHERY              :"Schusswaffen";0;0;0;0;({});({A_AG});0,\
  SK_THROWING             :"Wurfwaffen";0;0;0;0;({});({A_AG});0,\
  ])
#define SK_GROUP_FIGHTING ([\
  SK_DISARM               :"Entwaffnen";0;0;0;0;({});({A_AG,A_QU});0,\
  SK_FEINTING             :"Antaeuschen";0;0;0;0;({});({A_AG,A_QU});0,\
  SK_CLOSE_COMBAT         :"Nahkampf";0;0;0;0;({});({A_AG,A_QU});0,\
  SK_FURY                 :"Raserei";0;0;0;0;({});({A_QU,A_SD});0,\
  SK_FIGHT_HORSE          :"Kampf zu Pferd";0;0;0;0;({});({A_AG,A_EM});0,\
  SK_QUICKFIGHT           :"Schnellkampf";0;0;0;0;({});({A_QU,A_SD});0,\
  SK_ARMOUR               :"Bewegung in Ruestung";0;0;0;0;({});({});0,\
  SK_BODY_DEVELOPMENT     :"Koerperentwicklung";0;0;0;0;({});({});0,\
  ])
#define SK_GROUP_ATHLETIC ([\
  SK_CLIMBING             :"Klettern";0;0;0;0;({});({A_AG});0,\
  SK_SWIMMING             :"Schwimmen";0;0;0;0;({});({A_AG});0,\
  SK_ACROBATICS           :"Akrobatik";0;0;0;0;({});({A_AG});0,\
  SK_ENDURANCE            :"Ausdauer";0;0;0;0;({});({});0,\
  ])
#define SK_GROUP_CONCENTRATION ([\
  SK_PERCEPTION           :"Wahrnehmung";0;0;0;0;({});({A_RE,A_IN});0,\
  SK_EVADE                :"Ausweichen";0;0;0;0;({});({});0,\
  SK_USE_STRENGTH         :"Kraftakt";0;0;0;0;({});({A_SD});0,\
  SK_RESIST_PAIN          :"Schmerzresistenz";0;0;0;0;({});({A_CO,A_SD});0,\
  SK_MEDITATION_HEAL      :"Heilungsmeditation";0;0;0;0;({});({A_SD,A_PR});0,\
  SK_MEDITATION_SLEEP     :"Ruhemeditation";0;0;0;0;({});({A_SD,A_PR});0,\
  SK_MEDITATION_POWER     :"Kraftmeditation";0;0;0;0;({});({A_SD,A_PR});0,\
  SK_PORTAGING            :"Transportieren";0;0;0;0;({});({});0,\
  ])
#define SK_GROUP_MAGICAL ([\
  SK_ESSENCE              :"Essenzmagie";0;0;0;0;({});({A_EM});0,\
  SK_CHANNELING           :"Leitmagie";0;0;0;0;({});({A_IN});0,\
  SK_MENTALISM            :"Mentalmagie";0;0;0;0;({});({A_PR});0,\
  SK_RITUALS              :"Ritualmagie";0;0;0;0;({});({A_RE,A_EM});0,\
  SK_PSIONS               :"Psionik";0;0;0;0;({});({A_SD});0,\
  SK_POWER_PERCEPTION     :"Magie spueren";0;0;0;0;({});({A_EM});0,\
  SK_HIDE_SPELLS          :"Magie verbergen";0;0;0;0;({});({A_SD,A_PR});0,\
  SK_STRENGTHEN_SPELLS    :"Magie intensivieren";0;0;0;0;({});({A_EM});0,\
  SK_CHANNEL_POWER        :"Magie uebertragen";0;0;0;0;({});({A_IN});0,\
  SK_TRANSCENDENCE        :"Zaubern in Ruestung";0;0;0;0;({});({A_EM});0,\
  SK_MAGIC_LORE           :"Magiekunde";0;0;0;0;({});({A_RE});0,\
  SK_RUNES                :"Runenlesen";0;0;0;0;({});({A_RE,A_EM});0,\
  ])
#define SK_GROUP_ACADEMIC ([\
  SK_TACTICS              :"Kampftaktiken";0;0;0;0;({});({A_RE,A_PR});0,\
  SK_ALCHEMY              :"Alchemie";0;0;0;0;({});({A_RE});0,\
  SK_FLORA_LORE           :"Pflanzenkunde";0;0;0;0;({});({A_RE});0,\
  SK_METAL_LORE           :"Metallkunde";0;0;0;0;({});({A_RE});0,\
  SK_STONE_LORE           :"Steinkunde";0;0;0;0;({});({A_RE});0,\
  SK_NATURAL_LORE         :"Naturmaterialkunde";0;0;0;0;({});({A_RE});0,\
  SK_ELEMENTAL_LORE       :"Elementarkunde";0;0;0;0;({});({A_RE});0,\
  SK_CREATURE_LORE        :"Kreaturenkunde";0;0;0;0;({});({A_RE});0,\
  SK_WEAPON_LORE          :"Waffenkunde";0;0;0;0;({});({A_RE});0,\
  SK_ARMOUR_LORE          :"Ruestungskunde";0;0;0;0;({});({A_RE});0,\
  ])
#define SK_GROUP_MEDICAL ([\
  SK_FIRST_AID            :"Erste Hilfe";0;0;0;0;({});({A_SD,A_EM});0,\
  SK_SURGERY              :"Arzt";0;0;0;0;({});({A_SD,A_EM});0,\
  ])
#define SK_GROUP_SOCIAL ([\
  SK_DIPLOMACY            :"Diplomatie";0;0;0;0;({});({A_PR});0,\
  SK_TRADING              :"Handeln";0;0;0;0;({});({A_PR});0,\
  ])
#define SK_GROUP_SUBTERFUGE ([\
  SK_LOCKS                :"Schloesser oeffnen";0;0;0;0;({});({A_AG,A_IN});0,\
  SK_TRAPS                :"Fallen entschaerfen";0;0;0;0;({});({A_AG,A_IN});0,\
  SK_THIEVERY             :"Taschendiebstahl";0;0;0;0;({});({A_AG,A_PR});0,\
  SK_STEALTH              :"Heimlichkeit";0;0;0;0;({});({A_SD,A_PR});0,\
  ])
#define SK_GROUP_OUTDOOR ([\
  SK_RIDING               :"Reiten";0;0;0;0;({});({A_AG,A_IN});0,\
  SK_ANIMAL_HANDLING      :"Umgang mit Tieren";0;0;0;0;({});({A_IN,A_EM});0,\
  SK_FORAGING             :"Nahrungssuche";0;0;0;0;({});({A_RE,A_IN});0,\
  SK_WILDERNESS           :"Wildnisleben";0;0;0;0;({});({A_SD,A_IN});0,\
  ])
// all
#define ALL_SKILLS SK_GROUP_WEAPON+SK_GROUP_FIGHTING+SK_GROUP_ATHLETIC\
                  +SK_GROUP_CONCENTRATION+SK_GROUP_MAGICAL+SK_GROUP_ACADEMIC\
                  +SK_GROUP_MEDICAL+SK_GROUP_SOCIAL+SK_GROUP_SUBTERFUGE\
                  +SK_GROUP_OUTDOOR

// Ab hier is so gut wie alles obsolet

/* Properties */

//#define P_SKILLS                "skills"
#define P_MAX_SKILLS            "max_skills"
#define P_LAST_SKILL            "last_skill"
#define P_COMBAT_SKILLS         "combat_skills"
#define P_SKILLS_ID             "skills_id"

#define SM 			"/secure/skillmaster"
#define DEFAULT_ID              "SYS"

#define S_PROM                  0
#define S_TIME                  1
#define S_GIDS                  2
#define S_DIDS                  3
#define S_VERB                  4

/* skillmaster all abilities */
#define P_SM_ALL		-1
#define P_SM_DESCRIPTION 	0
#define P_SM_BEGIN		1
#define P_SM_LEVEL		2
#define P_SM_COST		3
#define P_SM_FACTOR		4
#define P_SM_STAT		5
#define P_SM_DELAY		6
#define P_SM_MAGIC		7
#define P_SM_TYPE		8 
#define P_SM_FILE		9
#define P_SM_ITEM		10
#define P_SM_VERBS              11
#define P_SM_FLAGS              12

/* flags */
#define SM_F_POLL               1  /* causes spellbook->_poll_<ability>(...) */
#define SM_F_GHOST              2  /* ability castable by ghosts (for Elric) */

/* Constants for Combat-Skills */
#define CS_ATTACK               0
#define CS_DEFEND               1

/* types of skills/spells (as stored in skillmaster) */
#define SM_SPELL                0
#define SM_SKILL                1
#define SM_COMBAT_SPELL         2   /* obsolete */
#define SM_ATTACK               3
#define SM_DEFEND               4
#define VALID_SM_TYPE(t)( member_array(t,\
                ({SM_SPELL, SM_SKILL, SM_ATTACK, SM_DEFEND}) ) != -1)

/* flags of find_argument() */
#define SM_ARG_ALL	 0
#define SM_ARG_LIVING	 1
#define SM_ARG_NOLIVING  2
#define SM_ARG_ENEMY	 3

/* general success-values */
#define ERFOLG2     2 /* for polling */
#define ERFOLG      1
#define MISSERFOLG  0
#define FEHLER     -1

/* structure of arrays in P_ACTIVE_SKILL */
#define P_ATT_STAT  0
#define P_ATT_FACT  1
#define P_ATT_MAGIC 2
#define P_DEF_STAT  0
#define P_DEF_FACT  1
#define P_DEF_MAGIC 2

#endif // __LIVING_SKILLS_H__

#ifdef NEED_PROTOTYPES

#ifndef __LIVING_SKILLS_H_PROTO__
#define __LIVING_SKILLS_H_PROTO__
                                 
/** new prototypes */

int QueryActiveSkill(string skill);
varargs int UseActiveSkill(string skill,int stop);
varargs int ActivateSkill(string skill, int success, int expire, mixed extra, mixed * expire_callback);
varargs int AddSkillRank(string skill, int skillrank);
varargs mapping SetSkills(mapping nskills);
int UseSkillRanks(string skill);
int QuerySkillRank(string skill);
int UseAttackSkill(string wt);
int UseSkill(string skill);
varargs int SkillCheck(string skill, int difficulty);
static varargs void OneSkillUse(string skill,string * use);
static void sumBoni(string skill, string descr, int ranks, int bonus, int cost, int uses, string * lastu, string * attr);
varargs static int calcBonus(string skill, string descr, int ranks, int bonus, int cost, int uses, string * lastu, string * attr);
static mapping _query_skills();
static mapping _query_active_skills();
void ExpireQuickfight(int flag);
int skill_cost(string skill);
varargs void RaiseSkills(int dp);

/** cmd prototypes */
int cmd_quickfight(string str);
int cmd_fury(string str);
int cmd_raise_skill(string str);

/* prototypes */

void AddSkillAction();

void SetActiveSkill();
static int IsCombatSkill(string SkillName);
static mixed GetArmourType(object obj);

int GetProbability(string SkillName);
int GiveAbility(string SkillName, int Wert);
int SetDelayTime(string ability, int del);
int QueryDelay(string ability);
int _cast_(string argument);

mixed QuerySkillIDs(string ability);
mixed QueryDisablerIDs(string ability);

int DisableSkill(string ability);
int EnableSkill(string ability);

int SetSkillVerbs(string skillname, mixed verbs);
mixed QuerySkillVerbs(string skillname);
static void create_liste();

#endif // __LIVING_SKILLS_H_PROTO__
#endif // NEED_PROTOYPES

