/*******************
** Eldarea MUDLib **
********************
**
** sys/material.h - material header
**
** CVS DATA
** $Date: 2000/12/04 15:17:34 $
** $Revision: 1.1 $
**
** CVS History
**
** $Log: material.h,v $
** Revision 1.1  2000/12/04 15:17:34  elatar
** initial release
**
**
**
*/

#ifndef _MATERIAL_H_
#define _MATERIAL_H_

#define MATERIAL_DIR "/global/service"
#define MATERIALDB MATERIAL_DIR"/materialdb"
#define MATERIAL_MANPAGE "/doc/eldarea/materials"

// help indices
#define MATI_NUMBER           -2  // laufende Nummer
#define MATI_INDEX            -1  // Index

// material mapping indices
#define MATI_NAME              0  // Name
#define MATI_GENDER            1  // Geschlecht
#define MATI_WEIGHT            2  // spezifisches Gewicht
#define MATI_AGGREGATE_STATE   3  // Aggregatzustand
#define MATI_HARDNESS          4  // Haertegrad
#define MATI_WEAROUT           5  // Verschleissgrad
#define MATI_REFLECTANCE       6  // Reflexionsgrad
#define MATI_TRANSPARENCE      7  // Transparenz
#define MATI_FLAMMABILITY      8  // Brennbarkeit
#define MATI_VOLATILIY         9  // Fluechtigkeit
#define MATI_FREEZABILITY     10  // Gefrierbarkeit
#define MATI_COLOR            11  // Farbe
#define MATI_VALUE            12  // Wert pro Gramm
#define MATI_MAGIC_SPHERE     13  // Magiebereich
#define MATI_MAGIC_RESISTANCE 14  // Magieresistenz
#define MATI_USABILITY        15  // Verarbeitbarkeit
#define MATI_MAGICAL_BONUS    16  // Magischer Bonus
#define MATI_TRANSCENDENCE    17  // Transzendierbarkeit
#define MATI_KNOWLEDGELEVEL   18  // Wissensstufe
#define MATI_MATERIAL_CLASSES 19  // Materialklassen
#define MATI_DESCRIPTION      20  // Beschreibung
#define MATI_KNOWLEDGE        21  // Wissensinfo

#define MATI_MAX_INDEX        21  // Maximaler Index

// prototypes
int AddMaterial(string id, mixed name, int gender, float weight, 
                int aggregate_state, int hardness, int wearout, 
                int reflectance, int transparence, int flammability,
                int volatility, int freezability, string color, int value,
                string magic_sphere, int magic_resistance, int usability,
                int magical_bonus, int transcendence, int knowledgelevel,
                mixed material_classes, string description, mixed knowledge);
                
static mapping _QueryMaterialInfo(mixed material, mixed info);
varargs mixed QueryMaterialInfo(mixed material, mixed info);               
void DumpMaterialList();
string ListMaterials();
int valid_material(string str);

#endif // _MATERIAL_H_
