/*******************
** Eldarea MUDLib **
********************
**
** sys/moving.h - moving header
**
** CVS DATA
** $Date: 2001/02/01 09:28:01 $
** $Revision: 1.3 $
**
** CVS History
**
** $Log: moving.h,v $
** Revision 1.3  2001/02/01 09:28:01  elatar
** E_MOVE_SOURCE implemented
**
** Revision 1.2  2000/12/04 14:44:41  elatar
** new moving handling defines
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#ifndef __MOVING_H__
#define __MOVING_H__

// Properties
#define P_MOVE_METHOD   "move_method" // default move method

// Methods to move objects
#define M_GO              1  // Living geht
#define M_TPORT           2  // Living teleportiert
#define M_NOCHECK         4  // einfaches Moven, ohne Checks
#define M_GET             8  // obj geht von Nonliving zu Living
#define M_PUT            16  // obj geht von Living zu Nonliving
#define M_GIVE           32  // obj geht von Living zu Living
#define M_DROP           64  // obj geht von Living ins Environment
#define M_SILENT        128  // obj soll ohne meldung ausgezogen werden
#define M_NO_ATTACK     256  // Kein Begruessungsschlag
#define M_NO_SHOW       512  // Zeige nicht die Room-Descr beim ankommen

// Hier folgt noch was fuer die Unit
#define M_MOVE_ALL     1024  // bewegt ein komlettes Unitobjekt
#define M_FORCE_SPLIT  2048  // bewegt Teile davon
#define M_NO_JOIN      4096  // Verhindert das automatische Vereinigen

// Nur fuer Lebewesen
#define M_MY_MSG       8192  // Verhindert Wirkung von P_MSG_FORCE


// Moven ohne Event
#define M_NOEVENT     16384  // Verwendung mit einem Erzmagier absprechen

// Neue Methoden
#define M_FLOAT       32768
#define M_FLY         65536
#define M_DRIVE      131072
#define M_SNEAK      524288
#define M_CLIMB     1048576
#define M_SWIM      2097152
#define M_DIVE      4194304
#define M_CRAWL     8388608
//16777216
//33554432
//67108864              

// Returnwerte fuer erfolgreiches move
#define MOVE_OK         1
#define MOVE_OK_SILENT  2

// Errors when moving things
#define ME_PLAYER            -1  // Hey, I'm a player and cant be simply carried away
#define ME_TOO_HEAVY         -2	 // Cant move into container because I'm too heavy
#define ME_CANT_TPORT_IN     -3  // Cant teleport there!
#define ME_CANT_TPORT_OUT    -4  // Cant teleport from here!
#define ME_CANT_BE_DROPPED   -5  // You cant drop the feel... this thing
#define ME_CANT_BE_TAKEN     -6  // Nope, you cannot take me
#define ME_CANT_BE_INSERTED  -7  // Container prevents me from inserting
#define ME_TOO_BULKY         -8  // Cant move into container because Im to bulky
#define ME_WORN              -9  // Objekt wird noch getragen
#define ME_WIELDED          -10  // Objekt ist noch gezueckt

#define NO_TPORT      1
#define NO_TPORT_IN   2
#define NO_TPORT_OUT  4

// Ablehnreaktionen von NPCs
#define REJECT_DROP         "reject_drop"
#define REJECT_GIVE         "reject_give"
#define REJECT_KEEP         "reject_keep"

// Move-Events
#define ET_GO               "et_go"
#define ET_TPORT            "et_tport"
#define ET_GET              "et_get"
#define ET_PUT              "et_put"
#define ET_GIVE             "et_give"
#define ET_DROP             "et_drop"

// Move-Event Defines
#define E_MOVE_OBJ          "e_move_obj"
#define E_MOVE_DEST         "e_move_dest"
#define E_MOVE_SOURCE       "e_move_source"
#define E_MOVE_METHOD       "e_move_method"
#define E_MOVE_DIRS         "e_move_dirs"
#define E_MOVE_VERBS        "e_move_verbs"
#define E_MOVE_EXHAUST      "e_move_exhaust"

// OBSOLETE
#define E_MOVE_MSGDIR       "e_move_msgdir"
#define E_MOVE_MSGLIV       "e_move_msgliv"
#define E_MOVE_MSGOUT       "e_move_msgout"
#define E_MOVE_MSGIN        "e_move_msgin"

#endif


