/*******************
** Eldarea MUDLib **
********************
**
** /sys/player.h - player object defines
**
** CVS DATA
** $Date: 2001/02/01 09:28:30 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: player.h,v $
** Revision 1.2  2001/02/01 09:28:30  elatar
** P_PATCHLEVEL implemented
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#ifndef _PLAYER_H_
#define _PLAYER_H_

#ifdef NEED_PROTOTYPES
#undef NEED_PROTOTYPES              // we need only the properties here!!
#define TMP_NEED_PROTOTYPES
#endif

#include "/sys/player/base.h"
#include "/sys/player/description.h"
#include "/sys/player/moving.h"
#include "/sys/player/filesys.h"
#include "/sys/player/potion.h"
#include "/sys/player/quest.h"
#include "/sys/living/skills.h"
#include "/sys/player/viewcmd.h"
#include "/sys/player/comm.h"
#include "/sys/player/stat.h"
#include "/sys/player/color.h"
#include <daemon.h>

#ifdef TMP_NEED_PROTOTYPES
#undef TMP_NEED_PROTOTYPES
#define NEED_PROTOTYPES
#endif

#define P_PATCHLEVEL    "patchlevel"

#define P_LAST_COMMAND_ENV "last_command_env"

#define P_NETDEAD_INFO "netdead_info"

#define P_ACTUAL_NOTIFY_FAIL "actual_notify_fail"

// 01.12.94 Troy
#define P_AUTOLOAD_SHADOW "autoload_shadow"

#define DeclareAutoload(name,param) \
  mlfp_create(({P_AUTOLOAD,name}),param)

#define UndeclareAutoload(name) \
  mlfp_remove(({P_AUTOLOAD}),name)

#define QueryAutoload(name) \
  mlfp_query(({P_AUTOLOAD,name}))

#ifdef NEED_PROTOTYPES
#endif

#endif
