/*******************
** Eldarea MUDLib **
********************
**
** sys/player/channel.h - channel header
**
** CVS DATA
** $Date: 2001/08/18 14:23:56 $
** $Revision: 1.4 $
**
** CVS History
**
** $Log: channel.h,v $
** Revision 1.4  2001/08/18 14:23:56  eldarea
** new default channels and channel aliases
**
** Revision 1.3  2000/12/04 14:59:00  elatar
** new channel header from md
**
** Revision 1.2  1999/11/19 10:40:21  elatar
** adapted to new channeld
**
**
*/
 
#ifndef __CHANNEL_H__
#define __CHANNEL_H__

// defines

#define EMPTY		0x0000
#define SAY		0x0001
#define EMOTE		0x0002
#define GEMOTE		0x0004
#define LOCK		0x0008
#define NEVER_LOCK	0x0010

//#define USAGE_COST      10
#define USAGE_COST	0
#define DEFAULT_CHANNELS ({"Abenteuer","Allgemein","Beileid","Grats","Info"})
#define DEFAULT_SHORTCUTS \
([                     \
 "b":"Abenteuer",      \
 "a":"Allgemein",      \
 "B":"Beileid",        \
 "q":"D-chat",         \
 "d":"D-Code",         \
 "G":"Grats",          \
 "T":"Tod",            \
 "P":"D-code",         \
 "D":"Debug",          \
 "O":"Intercode",      \
 "I":"Intermud",       \
 "i":"Info",           \
 "k":"Kultur",         \
 "l":"LPC",            \
 "x":"Linux",          \
 "v":"Avatar",         \
 "r":"Regionen",       \
 "g":"Grosser Rat"     \
])

// properties
#define P_CHANNELS      "channels"
#define P_STD_CHANNEL   "std_channel"
#define P_SWAP_CHANNELS  "swap_channels"
#define P_CHANNEL_SHORT  "channel_short"
 
#endif // __CHANNEL_H__

#ifdef NEED_PROTOTYPES

#ifndef __CHANNEL_H_PROTO__
#define __CHANNEL_H_PROTO__

// prototypes
int RegisterUser(object user);
int RemoveUser(object user);
int RegisterChannels(/*string channel, object user*/);
int RemoveChannels(/*string channel, object user*/);
mixed ChannelMessage(mixed msg, int nonint);

varargs int ListChannels(object user);
int ListUsers(string channel, object user);

varargs int SendToChannel(string channel, object user, int command, string msg);

#endif // __CHANNEL_H_PROTO__

#endif  // NEED_PROTOYPES

