/*******************
** Eldarea MUDLib **
********************
**
** sys/player/color.h - players color module
**
** CVS DATA
** $Date: 2000/12/04 14:59:42 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: color.h,v $
** Revision 1.2  2000/12/04 14:59:42  elatar
** new color handling defines
**
** Revision 1.1.1.1  1999/11/05 12:30:48  elatar
** Preparing mudlib for cvs control
**
**
*/
 
#ifndef __PLAYER_COLOR_H__
#define __PLAYER_COLOR_H__

#define P_COLORS				  "colors"
#define P_COLOR_GROUPS    "color_groups"

#define LEN_COLORIZE(len,str,col) \
  len+strlen(colorize(str,col))-strlen(str),\
  colorize(str,col)

// color groups
// players
#define CG_MAX_PL          49
#define CG_MAX_WIZ         100

#define CG_COLOR           0 // on/off

#define CG_TELL            1
#define CG_EXITS           2
#define CG_INFORM          3
#define CG_AWAIT           4
#define CG_CHANNEL1        5
#define CG_CHANNEL2        6
#define CG_CHANNEL3        7
#define CG_CHANNEL4        8
#define CG_CHANNEL5        9
#define CG_CHANNEL6       10
#define CG_CHANNEL7       11
#define CG_CHANNEL8       12
#define CG_FINGER         13
#define CG_LIVING         14
#define CG_INFO_NAME      15
#define CG_INFO_VAL       16
#define CG_INFO_BONUS     17
#define CG_WHO_AWAIT      18
#define CG_WHO_WIZARD     19
#define CG_PRIO1          20
#define CG_PRIO2          21
#define CG_PRIO3          22
#define CG_PRIO4          23
#define CG_PRIO5          24

// wizards
#define CG_PATH           50
#define CG_DETAILS        51
#define CG_LS_DIR         52
#define CG_LS_LOADED      53
#define CG_LS_C           54
#define CG_LS_H           55

#define COL_GROUP_NAMES ([CG_COLOR:     "Farbe",\
                          CG_TELL:      "teile-mit",\
                          CG_EXITS:     "ausgaenge",\
                          CG_INFORM:    "inform",\
                          CG_AWAIT:     "erwarte",\
                          CG_CHANNEL1:  "ebenen1",\
                          CG_CHANNEL2:  "ebenen2",\
                          CG_CHANNEL3:  "ebenen3",\
                          CG_CHANNEL4:  "ebenen4",\
                          CG_CHANNEL5:  "ebenen5",\
                          CG_CHANNEL6:  "ebenen6",\
                          CG_CHANNEL7:  "ebenen7",\
                          CG_CHANNEL8:  "ebenen8",\
                          CG_FINGER:    "finger",\
                          CG_LIVING:    "lebewesen",\
                          CG_INFO_NAME: "info-name",\
                          CG_INFO_VAL:  "info-wert",\
                          CG_INFO_BONUS:"info-bonus",\
                          CG_PRIO1:     "prio1",\
                          CG_PRIO2:     "prio2",\
                          CG_PRIO3:     "prio3",\
                          CG_PRIO4:     "prio4",\
                          CG_PRIO5:     "prio5",\
                          CG_PATH:      "pfade",\
                          CG_DETAILS:   "details",\
                          CG_LS_DIR:    "ls-dir",\
                          CG_LS_LOADED: "ls-loaded",\
                          CG_LS_C:      "ls-c",\
                          CG_LS_H:      "ls-h",\
                          CG_WHO_AWAIT: "wer-erwartet",\
                          CG_WHO_WIZARD:"wer-avatar"\
                          ])

#endif // __PLAYER_COLOR_H__

#ifdef NEED_PROTOTYPES

#ifndef __PLAYER_COLOR_H_PROTO__   
#define __PLAYER_COLOR_H_PROTO__

varargs string in_color(string cmd, string msg);
string colorize(string str, int color);

#endif // __PLAYER_COLOR_H_PROTO__

#endif // NEED_PROTOYPES
