/*******************
** Eldarea MUDLib **
********************
**
** std/player/comm.c - player communication module header
**
** CVS DATA
** $Date: 2000/12/04 15:00:23 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: comm.h,v $
** Revision 1.2  2000/12/04 15:00:23  elatar
** sound prototypes implemented
**
** Revision 1.1.1.1  1999/11/05 12:30:48  elatar
** Preparing mudlib for cvs control
**
**
*/
 
#ifndef __PLAYER_COMM_H__
#define __PLAYER_COMM_H__

// properties

#define P_CANECHO	"can_echo"
// #define P_INTERMUD      "intermud"   // Does she listen to it ? obsolet?
#define P_BUFFER        "buffer"
#define P_COMM_HOOKS    "comm_hooks"

#ifdef NEED_COMM_METHODS

#define COMM_EBENEN         1
#define COMM_SAGE           2
#define COMM_FRAGE          4
#define COMM_RUFE           8
#define COMM_TEILEMIT      16
#define COMM_ANTWORTE      32
#define COMM_SINGE         64
#define COMM_FLUESTERE    128
#define COMM_DENKE        256
#define COMM_EMOTE        512
#define COMM_ECHO        1024

#define COMM_ALL         ( COMM_EBENEN | COMM_SAGE | COMM_FRAGE | COMM_RUFE \
                           | COMM_TEILEMIT | COMM_ANTWORTE \
                           | COMM_SINGE | COMM_FLUESTERE | COMM_DENKE \
                           | COMM_EMOTE | COMM_ECHO )

#endif // NEED_COMM_METHODS

#endif // __PLAYER_COMM_H__

#ifdef NEED_PROTOTYPES

#ifndef __PLAYER_POTION_H_PROTO__
#define __PLAYER_POTION_H_PROTO__ 

// prototypes

varargs int FindPotion(string s);  // Was hat das denn HIER zu suchen?!? Fini

int AddCommHook(object ob, mixed fun, int meth);
int RemoveCommHook(object ob);
static string _comm_hook(string txt, int meth);
varargs void sound(string file, int repeats, int priority, int volume);
varargs void music(string file, int repeats, int volume);
void stopsound();
void stopmusic();
void startmusic();
static void send_sound(string file, int repeats, int priority, int volume);
static void send_music(string file, int repeats, int volume);

#endif // __PLAYER_POTION_H_PROTO__

#endif // NEED_PROTOYPES

