/*******************
** Eldarea MUDLib **
********************
**
** std/room/exit.h - room exit functions header
**
** CVS DATA
** $Date: 2001/06/18 18:23:21 $
** $Revision: 1.1 $
**
** CVS History
**
** $Log: exits.h,v $
** Revision 1.1  2001/06/18 18:23:21  elatar
** initial revision
**
**
**
*/

#ifndef _ROOM_EXITS_H_
#define _ROOM_EXITS_H_

// properties

#define P_EXITS                 "exits"

// mapping keys

#define EX_DEST                 "ex_dest"         // Zielraum
#define EX_TESTFUNC             "ex_testfunc"     // Nutzung erlaubt?
#define EX_FUNC                 "ex_func"         // Nutzung erfolgreich
#define EX_S_VERB               "ex_s_verb"       // Verb zum Verlassen
#define EX_D_VERB               "ex_d_verb"       // Verb zum Betreten
#define EX_S_MSG                "ex_s_msg"        // Meldung zum Verlassen
#define EX_D_MSG                "ex_d_msg"        // Meldung zum Betreten
#define EX_P_VERB               "ex_p_verb"       // Verb fuer den Spieler
#define EX_P_MSG                "ex_p_msg"        // Meldung fuer den Spieler
#define EX_FLAGS                "ex_flags"        // Flags, siehe unten
#define EX_CMDS                 "ex_cmds"         // Alternative Commands
#define EX_DIST                 "ex_dist"         // Entfernung des Zielraums
#define EX_ECHO                 "ex_echo"         // Wie gut traegt Schall da?
#define EX_WARD                 "ex_ward"         // Ist der Ausgang gewarded?
#define EX_METHODS              "ex_methods"      // Welche Fortbewegungsmethoden sind erlaubt?
#define EX_EXHAUST              "ex_exhaust"      // Wie anstrengend ists?
#define EX_GUARDS               "ex_guards"       // NPC die den Ausgang bewachen
#define EX_MAXSIZE              "ex_maxsize"      // Wie gross darf man sein?
#define EX_SIZEFAILMSG          "ex_sizefailmsg"  // Fehlermeldung, wenn man zu gross ist.

// exit flags

#define EXF_INACTIVE            1
#define EXF_HIDDEN              2
#define EXF_DOOR                4

#endif // _ROOM_EXITS_H_

#ifdef NEED_PROTOTYPES

#ifndef _ROOM_EXITS_PROTO_
#define _ROOM_EXITS_PROTO_

// prototypes
varargs void AddExit(string dir, mixed exit);
void RemoveExit(mixed cmd);
varargs string GetExits(object viewer);

#endif // _ROOM_EXITS_PROTO_

#endif	// NEED_PROTOYPES
