/*******************
** Eldarea MUDLib **
********************
**
** sys/rpgsys.c - rpg system handling
**
** CVS DATA
** $Date: 2000/12/04 15:18:07 $
** $Revision: 1.1 $
**
** CVS History
**
** $Log: rpgsys.h,v $
** Revision 1.1  2000/12/04 15:18:07  elatar
** initial release
**
**
*/

#ifndef _RPG_SYSTEM_HEADER_
#define _RPG_SYSTEM_HEADER_

// check difficulty level
#define CHD_TRIVIAL              50
#define CHD_ROUTINE              30
#define CHD_EASY                 20
#define CHD_LIGHT                10
#define CHD_NORMAL               0
#define CHD_MEDIUM               0
#define CHD_HARD                 -10
#define CHD_VERY_HARD            -20
#define CHD_VERYHARD             -20
#define CHD_EXTREMELY_HARD       -30
#define CHD_EXT_HARD             -30
#define CHD_EXTREMLYHARD         -30
#define CHD_SHEER_FOLLY          -50
#define CHD_SHEERFOLLY           -50
#define CHD_ABSURD               -70
#define CHD_INSANE               -100
#define CHD_SUPERNATURAL         -150
#define CHD_VIRTUALLY_IMPOSSIBLE -200
#define CHD_VIRTUALLYIMPOSSIBLE  -200
#define CHD_VIRT_IMPOSSIBLE      -200

// EvalCheckResult() return values
#define CH_LEGENDARY_SUCCESS    4
#define CH_SPECTACULAR_SUCCESS  3
#define CH_ABSOLUTE_SUCCESS     2
#define CH_SUCCESS              1
#define CH_FAILURE              0
#define CH_ABSOLUTE_FAILURE     -1
#define CH_SPECTACULAR_FAILURE  -2
#define CH_BLUNDER              -3

// check result threshholds, not very interesting
#define CHRT_SUCCESS_THRESHOLD  100

#define CHRT_BLUNDER             -1000..-250
#define CHRT_SPECTACULAR_FAILURE -249..-150
#define CHRT_ABSOLUTE_FAILURE    -149..5
#define CHRT_FAILURE             6..CHRT_SUCCESS_THRESHOLD-1
#define CHRT_SUCCESS             CHRT_SUCCESS_THRESHOLD..174
#define CHRT_ABSOLUTE_SUCCESS    175..249
#define CHRT_SPECTACULAR_SUCCESS 250..349
#define CHRT_LEGENDARY_SUCCESS   350..1000

#endif //_RPG_SYSTEM_HEADER_