/*******************
** Eldarea MUDLib **
********************
**
** sys/thing/description.h - object description header
**
** CVS DATA
** $Date: 2000/12/04 15:03:29 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: description.h,v $
** Revision 1.2  2000/12/04 15:03:29  elatar
** new prototype for Name()
** new prototypes for light handling
** properties from other headers: P_LIGHT, P_CLONER
** new properties: P_DAYTIME_LIGHT, P_TRANSLUCENT
**
** Revision 1.1.1.1  1999/11/05 12:30:48  elatar
** Preparing mudlib for cvs control
**
**
*/
 
#ifndef __THING_DESCRIPTION_H__
#define __THING_DESCRIPTION_H__

// properties
#define P_NAME            "name"            // name of the object
#define P_PLURAL          "plural"          // plural name of the object
#define P_NAME_ADJ        "name_adj"        // adjective of the name of the object
#define P_LONG            "long"            // long description of the object
#define P_IDS             "ids"             // identifier of the object
#define P_ADJECTIVES      "adjectives"      // adjectives of the object
#define P_DESCR           "descr"           // additional info for name
#define P_MAGIC           "magic"           // Magie des Objekts
#define P_LIGHT           "light"           // Helligkeit des Objekts
#define P_DAYTIME_LIGHTS  "daytime_lights"  // Helligkeit zu den unterschiedlichen Tageszeiten
#define P_TRANSLUCENT     "translucent"     // Objekt laesst Licht durch
#define P_CLONER          "cloner"          // Cloner des Objekts

// Modi fuer name()
#define NAME_INDEF    0        // unbestimmter Artikel
#define NAME_DEF      1        // bestimmter Artikel
#define NAME_AUTO     2        // Artikel automatisch bestimmen
#define NAME_DESCR    4        // Beschreibender Modus mit P_DESCR
#define NAME_PLURAL   8        // Plural erzeugen wenn moeglich
#define NAME_UACT    16        // Units vorher aktualisieren

#endif // __THING_DESCRIPTION_H__

#ifdef NEED_PROTOTYPES

#ifndef __THING_DESCRIPTION_H_PROTO__
#define __THING_DESCRIPTION_H_PROTO__

// prototypes
// check if the objects can by identified by str
varargs int id(string str, int lvl);

// add an id to the current object
varargs void AddId(mixed sing, mixed plur);

// add an adjective to describe the object
void AddAdjective(mixed str);

// get the name with casus and demonstrative
varargs string name(int casus, int demon);
// same with capitalize
varargs string Name(int casus, int demon);

// light handling
varargs int QueryInternalLight(object exclude);
varargs int QueryExternalLight();
#endif // __THING_DESCRIPTION_H_PROTO__

#endif	// NEED_PROTOYPES
