/*******************
** Eldarea MUDLib **
********************
**
** sys/thing/lore.h - lores header file
**
** CVS DATA
** $Date: 2000/12/04 15:04:19 $
** $Revision: 1.2 $
**
** this propertie holds all information needed for lore skill resolving
**
** CVS History
**
** $Log: lore.h,v $
** Revision 1.2  2000/12/04 15:04:19  elatar
** new lore handling prototypes and defines
**
** Revision 1.1  1999/11/12 11:03:51  elatar
** Initial revision
**
**
*/

#ifndef __THING_LORE_H__
#define __THING_LORE_H__

#define P_DETAIL_LORE "detail_lore"

#define ZERO_LORES ([SK_RUNES:([0:"Mit Runen hat %s nichts zu tun."])\
                    ,SK_MAGIC_LORE:([0:"Magische Eigenschaften scheint %s nicht zu haben."])\
                    ,SK_TACTICS:([0:"%s scheint keine besonderen taktischen Vorteile zu bringen."])\
                    ,SK_FLORA_LORE:([0:"Mit Pflanzen hat %s nichts zu tun."])\
                    ,SK_CREATURE_LORE:([0:"Mit Lebewesen %s das nichts zu tun."])\
                    ,SK_ALCHEMY:([0:"Mit Alchemie hat %s nichts zu tun."])\
                    ,SK_ELEMENTAL_LORE:([0:"Mit den Elementen hat %s nichts zu tun."])\
                    ,SK_METAL_LORE:([0:"Mit Metall hat %s nichts zu tun."])\
                    ,SK_STONE_LORE:([0:"Mit Mineralien hat %s nichts zu tun."])\
                    ,SK_NATURAL_LORE:([0:"Mit organischen Materialien hat %s nichts zu tun."])\
                    ,SK_WEAPON_LORE:([0:"Mit Waffen hat %s nichts zu tun."])\
                    ,SK_ARMOUR_LORE:([0:"Mit Ruestungen hat %s nichts zu tun."])\
                     ])
 
#endif //__THING_LORE_H__

#ifdef NEED_PROTOTYPES

#ifndef __THING_LORE_H_PROTO__
#define __THING_LORE_H_PROTO__

//prototypes

//add lore to a detail. it will be identified by the detail id
void AddDetailLore(string detail, string lore, mapping newlore);

//remove lore from one detail. detail 0 will remove all lores, lore 0 will remove all lores
// from one detail
varargs void RemoveDetailLore(string detail, string lore);

//return lore at detail
mapping QueryLore(string detail,string lore);

#endif //__THING_LORE_H_PROTO__

#endif //NEED_PROTOTYPES
