/*******************
** Eldarea MUDLib **
********************
**
** sys/thing/material.h - material handling header
**
** CVS DATA
** $Date: 2000/08/15 08:29:03 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: material.h,v $
** Revision 1.2  2000/08/15 08:29:03  eldarea
** material handling reimplemented
**
** Revision 1.1.1.1  1999/11/05 12:30:48  elatar
** Preparing mudlib for cvs control
**
**
*/

#ifndef __THING_MATERIAL_H__
#define __THING_MATERIAL_H__

// properties
#define P_MATERIAL        "material"      // material
#define P_HARDNESS        "hardness"      // hardness
#define P_WEAROUT         "wearout"       // wearout
#define P_TRANSCENDENCE   "transcendence" // transcendence modifier

#define MATERIAL(x)    "material_"x

#define MAT_MISC        MATERIAL("Unknown")

#define MAT_WOOD        MATERIAL("Wood")
#define MAT_HORN        MATERIAL("Horn")
#define MAT_LEATHER     MATERIAL("Leather")
#define MAT_CLOTH       MATERIAL("Cloth")
#define MAT_FUR         MATERIAL("Fur")
#define MAT_PAPER       MATERIAL("Paper")

#define MAT_STONE       MATERIAL("Stone")
#define MAT_GLASS       MATERIAL("Glass")
#define MAT_METAL       MATERIAL("Metal")
#define MAT_CERAMIC     MATERIAL("Ceramic")

// Metals
#define MAT_SILVER      MATERIAL("Silver")
#define MAT_GOLD        MATERIAL("Gold")
#define MAT_IRON        MATERIAL("Iron")
#define MAT_COPPER      MATERIAL("Copper")
#define MAT_BRONZE      MATERIAL("Bronze")
#define MAT_MITHRIL     MATERIAL("Mithril")
#define MAT_ADAMANTITE	MATERIAL("Adamantite")	// Fuer Drow-Waffen und -ruestungen :)

#define MAT_BRONCE      MAT_BRONZE          // wird am 01.01.1997 entfernt!

#define MAT_ORGANIC     MATERIAL("Organic")
#define MAT_LIVING      MATERIAL("Living")
#define MAT_CORPSE      MATERIAL("Corpse")

#define MAT_AIR         MATERIAL("Air")
#define MAT_ICE         MATERIAL("Ice")
#define MAT_FIRE        MATERIAL("Fire")
#define MAT_WATER       MATERIAL("Water")
#define MAT_MAGIC       MATERIAL("Magic")

#endif // __THING_MATERIAL_H__

#ifdef NEED_PROTOTYPES

#ifndef __THING_MATERIAL_H_PROTO__
#define __THING_MATERIAL_H_PROTO__

// prototypes

varargs string mat2string(string mat, int casus);
// wandelt eine Materialkonstante in einen lesbaren String, also
// z.B. mat2string(MAT_WOOD, WESSEN) == "Holzes"

void matmap(string key,int val, int casus, string str);
//fuer walk_mapping

string MatList(int casus);
// erstellt eine Liste der Materialien des Objektes

int QueryShare(string mat);
// gibt den anteil von mat zurueck

#endif // __THING_MATERIAL_H_PROTO__

#endif // NEED_PROTOYPES
