/*******************
** Eldarea MUDLib **
********************
**
** sys/thing/moving.h - moving header
**
** CVS DATA
** $Date: 2000/12/19 18:00:45 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: moving.h,v $
** Revision 1.2  2000/12/19 18:00:45  elatar
** implemented deep_remove()
**
** Revision 1.1.1.1  1999/11/05 12:30:48  elatar
** Preparing mudlib for cvs control
**
*/
 
#ifndef __THING_MOVING_H__
#define __THING_MOVING_H__

// properties
#define P_NODROP  "nodrop"  // can't be dropped
#define P_NOGET   "noget"   // can't be taken

#endif // __THING_MOVING_H__

#ifdef NEED_PROTOTYPES

#ifndef __THING_MOVING_H_PROTO__
#define __THING_MOVING_H_PROTO__

// prototypes
// move the object from current position to dest using the method
int move(mixed dest, int method);

// remove the object return 1 for successful destruction
varargs int remove();
// remove the object an the complete inventory
nomask varargs int deep_remove(int force, int silent);

#endif // __THING_MOVING_H_PROTO__

#endif	// NEED_PROTOYPES
