/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:48 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: properties.h,v $
** Revision 1.1.1.1  1999/11/05 12:30:48  elatar
** Preparing mudlib for cvs control
**
**
*/
// MD-MUDlib
//
// /sys/thing/properties.h -- contains property definitions and prototypes


#ifndef __THING_PROPERTIES_H__
#define __THING_PROPERTIES_H__

// properties

#define P_UID    "uid"
#define P_EUID   "euid"

#define P_SMELL  "smell"          // listen to the object
#define P_SOUND  "sound"          // to smell the object

// special defines

#define F_VALUE         0
#define F_MODE          1
#define F_SET_METHOD    2
#define F_QUERY_METHOD  3
#define F_MODE_AS       4
#define F_MODE_AD       5

#define SAVE            64
#define PROTECTED       128  // only this_object() can change the values
#define SECURED         256  // like PROTECTED, but never resetable
#define NOSETMETHOD     512  // Keine Set-Methode => Nicht mofifizierbar
#define SETMNOTFOUND   1024  // Keine Set-Methode gefunden
#define QUERYMNOTFOUND 2048  // Keine Query-Methode gefunden
#define QUERYCACHED    4096
#define SETCACHED      8192

#endif // __THING_PROPERTIES_H__

#ifdef NEED_PROTOTYPES

#ifndef __THING_PROPERTIES_H_PROTO__
#define __THING_PROPERTIES_H_PROTO__

// prototypes

// direct property access
varargs mixed Set(string name, mixed Value, int Type); 
varargs mixed Query(string name, int Type);

// filtered property access
mixed SetProp(string name, mixed Value);
mixed QueryProp(string name);

// global property handling
void SetProperties(mapping props);
mapping QueryProperties();

#endif // __THING_PROPERTIES_H_PROTO__

#endif // NEED_PROTOTYPES
