/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:48 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: udp.h,v $
** Revision 1.1.1.1  1999/11/05 12:30:48  elatar
** Preparing mudlib for cvs control
**
**
*/
// MD Mudlib
// Based on Wunderland Mudlib
//
// /sys/udp.h - udp-headerfile
//
// $Revision: 1.1.1.1 $
// $Date: 1999/11/05 12:30:48 $
// $Log: udp.h,v $
// Revision 1.1.1.1  1999/11/05 12:30:48  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:15  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/08/10 20:15:54  Big
// Initial revision
//

#ifndef __UDP_H__
#define __UDP_H__

/* --- User Configuration. --- */

#include "/secure/config.h"

#define LOCAL_NAME      MUDNAME
#define INETD		"/secure/inetd"
#define UDP_CMD_DIR	"/secure/udp/"

#ifndef TESTMUD
#define HOST_FILE	"/etc/INETD_HOSTS"
#else
#define HOST_FILE       "/etc/INETD_HOSTS.TESTMUD"
#endif

#define INETD_LOG_FILE	"INETD"

#define REPLY_TIME_OUT	12
#define RETRIES		2

#define LOCAL_UDP_PORT	query_imp_port()

/* --- End of config. --- */

#define INETD_DIAGNOSTICS

#define INETD_VERSION	(INETD->inetd_version())

/* --- Standard header macros. --- */

#define RECIPIENT	"RCPNT"
#define REQUEST		"REQ"
#define SENDER		"SND"
#define DATA		"DATA"

/* These headers are reserved for system use only. */
#define HOST		"HST"
#define ID		"ID"
#ifndef NAME
#define NAME		"NAME"
#endif
#define PACKET		"PKT"
#define UDP_PORT	"UDP"
#define SYSTEM		"SYS"

/* Reserved headers for diagnostics. */
#define PACKET_LOSS	"PKT_LOSS"
#define RESPONSE_TIME	"TIME"

/* --- Standard REQUEST macros. --- */

#define PING		"ping"
#define QUERY		"query"
#define REPLY		"reply"

/* --- Standard SYSTEM macros. --- */

#define FAILED		"F"
#define REPEAT		"R"
#define TIME_OUT	"TO"
#define UNAVAILABLE	"U"

/* --- Index macros for host arrays. --- */

#define HOST_NAME	0
#define HOST_IP		1
#define HOST_UDP_PORT	2
#define LOCAL_COMMANDS	3
#define HOST_COMMANDS	4
#define HOST_STATUS	5

#endif
