/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:48 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: www.h,v $
** Revision 1.1.1.1  1999/11/05 12:30:48  elatar
** Preparing mudlib for cvs control
**
**
*/
// MD MUDlib
// Based on Wunderland MUDlib 
//
// /sys/www.h -- World Wide Web Services
//
// $Revision: 1.1.1.1 $
// $Date: 1999/11/05 12:30:48 $
// $Log: www.h,v $
// Revision 1.1.1.1  1999/11/05 12:30:48  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:15  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/08/10 20:13:10  Big
// Initial revision
//

#include <service.h>
#include <config.h>

// how do you spell your mud name
#ifndef MUDNAME
# define MUDNAME	"MD"
#endif

// Pathnames to different services
// INETD -- the inet daemon
#ifndef INETD
# define INETD		"/secure/inetd"
#endif

#define FINGER(n)       FINGEROBJ->finger(n,"\nhsp")
#define WHO		"/global/service/werliste"->QueryWhoListe(0,0,1)

// UDPPATH -- wherethe udp programs are
#define UDPPATH		"/secure/udp"

// the WWW request scheduler
#define WWW   		(UDPPATH+"/www")
#define TIMEOUT		5

// wher to log all WWW UDP Requests
#define WWWLOG "WWW"			// used in log_file()

// define MUDHOST, WWW SERVER address and the ICON URL
#ifndef MUDHOST
# define MUDHOST		"mud.cs.uni-magdeburg.de"
#else
# undef MUDHOST
# define MUDHOST           "mud.cs.uni-magdeburg.de"
#endif
#define MUDUSER		"mud"
#define SERVER 		"mud.cs.uni-magdeburg.de"
#define ICONS		"/symbole"
#define MUDWWW		"/cgi-bin/mudwww"

// define the address of the MUD Host
#define HOMEPAGE		"http://"+SERVER+":8080/"
#define MUDMAIL		"mailto:"+MUDUSER+"@"+MUDHOST

// some icons needed to navigate the pages
#define I_GO_BACK	ICONS+"/blue_left.gif"
#define I_GO_UP		ICONS+"/blue_up.gif"
#define I_GO_HOME	ICONS+"/blue_top.gif"
#define I_MAIL		ICONS+"/mail.gif"

// the text to prepend to any mudwww request answers
#define PAGEHEAD \
  "<HTML>" \
+ "<HEAD><TITLE>"+MUDNAME+"-WWW</TITLE></HEAD>" \
+ "<BODY BGCOLOR=#FFFFFF>"

// append the following text to any mudwww request answer
// please do not remove the four lines before </BODY></HTML>
#define PAGETAIL \
  "<HR><H2><P ALIGN=\"CENTER\">" \
+ "<A HREF=\"telnet://"+MUDHOST+":4711/\">"+MUDNAME+" jetzt spielen !</A></H2>" \
+ "<BR><CENTER>" \
+ "| <A HREF=\"/index.html\">Hauptseite des MD-MUDs</A> |" \
+ " <A HREF=\"/mud/p_hand.html\">Spielerhandbuch</A> |" \
+ " <A HREF=\"/mud/m_hand.html\">Magierhandbuch</A> |" \
+ "</CENTER>" \
+ "<BR><HR><BR>" \
+ "<ADDRESS>" \
+ "<IMG BORDER=0 SRC=\""+I_MAIL+"\" ALT=\"EMAIL\">" \
+ "<A HREF=\""+MUDMAIL+"\">"+MUDUSER+"@"+MUDHOST+"</A>" \
+ "</ADDRESS>" \
+ "<H6 ALIGN=\"CENTER\"><B><I>MudWWW[lp]</I></B> " \
+ "-- &copy; 1994,95 by " \
+ "<A HREF=\"mailto:mud@mg.mud.de\">Morgengrauen</A> &amp; 1999 by " \
+ "<A HREF=\"mailto:mud@cs.uni-magdeburg.de\">MD-MUD</A></H6>" \
+ "</BODY></HTML>"

// Request Syntax tokens
#define REQ     "REQ"		// TYPE of REQuest

// The WWW Newsreader
# define R_NEWS     "news"		// - we would like to read news
#  define GROUP       "GROUP"	//   * which newsgroup  
#  define ARTICLE     "ARTICLE"	//   * which article

// The WWW MUD Walker
# define R_WALK     "walk"		// - or maybe walk around a bit
#  define ROOM        "ROOM"	//   * ROOM to enter
#  define DETAIL      "DETAIL"	//   * DETAIL to examine

// The WWW Finger Request
# define R_FINGER   "finger"	// - finger someone
#  define USER        "USER"	//   * USER to retrieve info from

// The WWW Wholist Request
# define R_WHO      "who"		// - get the wholist

// The WWW Intermud Gateway
# define R_INTERMUD "intermud"	// - intermud communication request
#  define IMUD        "IMUD"	//   * The MUD to request info from
#  define TYPE        "TYPE"	//   * The TYPE of Request
#  define IDATA       "DATA"	//   * extra DATA to aid request
#  define PAGE        "PAGE"	//   * Alphabetical pages of muds

#define BACK    "BACK"		// PAGE to go BACK to

#ifndef MUDNAME
# define MUDNAME "TestMUD"
#endif /* MUDNAME */

// Property specific defines
#if MUDNAME == "MorgenGrauen"
# define P_WWWINFO	"wwwinfo"
#endif

// The error message to view in any case
#define ERROR(str)	"<H1>Ein Fehler ist aufgetreten !</H1><HR>"+str

// debugging (change name to your own!)
#define DNAME	"largo"
#define DEBUG(str) if(find_player(DNAME)) \
                     tell_object(find_player(DNAME), sprintf("%O\n", str))
//#undef DEBUG						       

